<?php
/**
 * Plugin Name: Veno File Manager
 * Version: 4.4.7
 *
 * @category  PHP
 * @package   VenoFileManager
 * @author    Nicola Franchini <info@veno.it>
 * @copyright 2013 - 2025 Nicola Franchini
 * @license   Exclusively sold on CodeCanyon: https://codecanyon.net/item/veno-file-manager-host-and-share-files/6114247
 * @link      https://filemanager.veno.it/
 */
define('VFM_APP', true);
require_once __DIR__.'/vfm-admin/include/head.php';
require_once __DIR__.'/vfm-admin/include/activate.php';
?>
<!doctype html>
<html lang="<?php echo $setUp->lang; ?>"<?php echo $rtl_att; ?> data-bs-theme="<?php echo $setUp->getConfig("color_theme", "light"); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title><?php echo $setUp->getConfig("appname"); ?></title>
    <?php echo $setUp->printIcon("vfm-admin/_content/uploads/"); ?>

    <meta name="description" content="File Manager">
    <?php require 'vfm-admin/include/load-css.php'; ?>
    <script type="text/javascript" src="vfm-admin/assets/jquery/jquery-3.6.1.min.js"></script>

</head>
    <body id="uparea" class="<?php echo $bodyclass; ?>"<?php echo $bodydata; ?>>
        <div id="error"><?php echo $setUp->printAlert(); ?></div>
        <div class="overdrag"></div>
            <?php
            /**
             * ******************** HEADER ********************
             */
            if ($setUp->getConfig('header_position') == 'above') {
                include __DIR__.'/vfm-admin'.$template->includeTpl('header');
                include __DIR__.'/vfm-admin'.$template->includeTpl('navbar');
            } else {
                include __DIR__.'/vfm-admin'.$template->includeTpl('navbar');
                include __DIR__.'/vfm-admin'.$template->includeTpl('header');
            }
            ?>
        <div class="container mb-auto pt-3">
            <div class="main-content row">
            <?php
            if ($getdownloadlist) :
                /**
                 * ********* SARED FILES DOWNLOADER *********
                 */
                include __DIR__.'/vfm-admin'.$template->includeTpl('downloader');
            elseif ($getrp) :
                /**
                 * **************** PASSWORD RESET ****************
                 */
                include __DIR__.'/vfm-admin'.$template->includeTpl('reset');
            else :
                /**
                 * **************** FILEMANAGER **************
                 */
                if (!$getreg || !$setUp->getConfig('registration_enable')) {
                    include __DIR__.'/vfm-admin/include/user-redirect.php';
                    include __DIR__.'/vfm-admin'.$template->includeTpl('remote-uploader');
                    include __DIR__.'/vfm-admin'.$template->includeTpl('notify-users');
                    include __DIR__.'/vfm-admin'.$template->includeTpl('uploadarea');
                    include __DIR__.'/vfm-admin'.$template->includeTpl('breadcrumbs');
                    include __DIR__.'/vfm-admin'.$template->includeTpl('list-folders');
                    include __DIR__.'/vfm-admin'.$template->includeTpl('list-files');
                    include __DIR__.'/vfm-admin'.$template->includeTpl('disk-space');
                }
                if ($getreg && $setUp->getConfig('registration_enable')) {
                    include __DIR__.'/vfm-admin'.$template->includeTpl('register');
                } else {
                    include __DIR__.'/vfm-admin'.$template->includeTpl('login');
                }
            endif; ?>
            </div> <!-- .main-content -->
        </div> <!-- .container -->
        <?php
        /**
         * ******************** FOOTER ********************
         */
        require __DIR__.'/vfm-admin'.$template->includeTpl('footer');
        require __DIR__.'/vfm-admin'.$template->includeTpl('modals');
        require __DIR__.'/vfm-admin/include/load-js.php';
        ?>
    </body>
</html>