<?php
/**
 * VFM - veno file manager: ajax/get-filetree.php
 *
 * Display folder tree
 *
 * PHP version >= 5.3
 *
 * @category  PHP
 * @package   VenoFileManager
 * @author    Nicola Franchini <support@veno.it>
 * @copyright 2013 Nicola Franchini
 * @license   Exclusively sold on CodeCanyon
 * @link      http://filemanager.veno.it/
 */
if (!isset($_SERVER['HTTP_X_REQUESTED_WITH']) 
    || (isset($_SERVER['HTTP_X_REQUESTED_WITH']) && strtolower($_SERVER['HTTP_X_REQUESTED_WITH']) !== 'xmlhttprequest')
) {
    exit;
}
require_once dirname(__DIR__).'/class/class.utils.php';
require_once dirname(__DIR__).'/class/class.setup.php';
require_once dirname(__DIR__).'/class/class.gatekeeper.php';
require_once dirname(__DIR__).'/class/class.actions.php';

$setUp = new SetUp();
$gateKeeper = new GateKeeper();

$currentdir = base64_decode(filter_input(INPUT_POST, 'currentdir', FILTER_SANITIZE_SPECIAL_CHARS));
$__root = filter_input(INPUT_POST, '__root', FILTER_SANITIZE_SPECIAL_CHARS);
$action = filter_input(INPUT_POST, 'action', FILTER_SANITIZE_SPECIAL_CHARS);
$checkbox = filter_input(INPUT_POST, 'checkbox', FILTER_SANITIZE_SPECIAL_CHARS);
$selected = isset($_POST['selected']) ? json_decode($_POST['selected']) : array();

$starting_dir = $setUp->getConfig('starting_dir');

$href = ($action == 'breadcrumbs') ? true : false;
$movelink = ($action == 'breadcrumbs') ? '' : 'movelink';

$getuserDirs = $gateKeeper->getUserInfo('dir');

$output = '<div class="wrap-foldertree"><span class="toggle-all-tree"><i class="bi bi-dash-square-fill tree-toggler"></i></span>';
$output .= '<ul class="foldertree">';
$output .= '<li class="folderoot">';

// check if any folder is assigned to the current user
if ($getuserDirs !== null) {

    $userpatharray = json_decode($getuserDirs, true);

    $output .= '<i class="bi bi-folder2-open"></i>';
    $output .= '<ul>';
    // Natural sort order
    natcasesort($userpatharray);
    // show all available directories trees
    foreach ($userpatharray as $userdir) {
        $path = $starting_dir.$userdir.'/';

        $output .= '<li>';

        if ($path === $currentdir || $checkbox) {
            $output .= '<i class="bi bi-folder2-open"></i> <span class="search-highlight">'.$userdir.'</span>';
        } else {
            $output .= '<a href="?dir='.urlencode(ltrim($path, './')).'" data-dest="'.urlencode($path).'" class="'.$movelink.'">';
            $output .= '<i class="bi bi-folder"></i> '.$userdir;
            $output .= '</a>';
        }

        $scansub = glob('../.'.$path.'*', GLOB_ONLYDIR);

        if (count($scansub) > 0) {
            $output .= '<span class="toggle-tree"><i class="bi bi-dash-square tree-toggler bg-lighter"></i></span>';
        }
        $output .= Actions::walkDir($path, $currentdir, $href, '../.', $checkbox, $selected);
        $output .= '</li>';
    }
    $output .= '</ul>';

} else {

    // No directory assigned, access to all folders
    $cleandir = substr_replace(substr($starting_dir, 2), '', -1);
    $cleandir = strlen($cleandir) > 0 ? $cleandir : $__root;

    if ($starting_dir === $currentdir || $checkbox) {
        $output .= '<i class="bi bi-folder2-open"></i> <span class="search-highlight">'.$cleandir.'</span>';
    } else {
        $output .= '<a href="?dir='.urlencode(ltrim($starting_dir, './')).'" data-dest="'.urlencode($starting_dir).'" class="'.$movelink.'">';
        $output .= '<i class="bi bi-folder"></i> '.$cleandir;
        $output .= '</a>';
    }

    $output .= Actions::walkDir($starting_dir, $currentdir, $href, '../.', $checkbox, $selected);
}

$output .= '</li></ul></div>';

echo json_encode($output);
exit;
