<?php
/**
 * LANGUAGES SETTINGS
 */
?>
<div class="row mb-3">
    <div class="col-sm-12">
        <div class="card" id="view-languages">
            <div class="card-header d-flex justify-content-center align-items-center">
                <h4 class="m-0"><i class="bi bi-globe2"></i> <?php print $setUp->getString("languages"); ?></h4>
                <button type="button" class="btn ms-auto" data-bs-toggle="collapse" data-bs-target="#card-languages" aria-expanded="false">
                    <i class="bi bi-dash-lg"></i>
                </button>
            </div>
            <div class="collapse show" id="card-languages">
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-4 mb-2">
                            <label class="form-label"><?php echo $setUp->getString("default_lang"); ?></label>
                            <select class="form-select" name="lang">
<?php
foreach ($translations as $key => $lingua) {
    $langselected = $key == $setUp->getConfig('lang') ? ' selected' : '';
    ?>
                                <option value="<?php echo $key; ?>"<?php echo $langselected; ?>><?php echo $lingua; ?></option>
    <?php
} ?>
                            </select>
                        </div>
                        <div class="col-lg-8 mb-2">
<?php
$active_languages = $setUp->getConfig('active_languages', false) ? json_decode($setUp->getConfig('active_languages')) : array('en'); 
?>
                            <label class="form-label">
                                <?php print $setUp->getString("active_languages"); ?>
                            </label>
                            <div class="form-group">
                                <?php
                                foreach ($translations as $key => $lingua) {
                                    $checked = in_array($key, $active_languages) ? 'checked' : '';
                                    ?>
                                <div class="form-check form-check-inline mb-3 me-3">
                                  <input type="checkbox" name="active_languages[]" class="form-check-input" id="check-language-<?php echo $key; ?>" autocomplete="off" value="<?php echo $key; ?>"
                                    <?php echo $checked; ?>>
                                  <label class="form-check-label" for="check-language-<?php echo $key; ?>"><span class="badge bg-light"><?php echo $lingua; ?></span></label>
                                </div>
                                    <?php
                                } ?>
                            </div>
                        </div> <!-- col-lg-8 -->
<?php 
?>
                    </div> <!-- row -->
                </div> <!-- card-body -->
            </div> <!-- collapse -->
        </div> <!-- card -->
    </div> <!-- col-12 -->
</div> <!-- row -->
